<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  core
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

// include defines
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'defines.php';

$adapters = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'vikbooking' . DIRECTORY_SEPARATOR . 'autoload.php';

if (!is_file($adapters))
{
    throw new RuntimeException(
        '<span>VikBooking must be installed on your website!</span>&nbsp;<a href="plugin-install.php?s=vikbooking&tab=search&type=term">Install VikBooking</a>',
        404 // not found
    );
}

require_once ABSPATH . 'wp-admin/includes/plugin.php';

// make sure VikBooking is also active
if (!is_plugin_active('vikbooking/vikbooking.php'))
{
    throw new RuntimeException(
        '<span>VikBooking must be active!</span>&nbsp;<a href="plugins.php?plugin_status=all&paged=1&s=vikbooking">Activate VikBooking</a>',
        423 // locked
    );
}

// include VikBooking's autoloader
require_once $adapters;

// make sure the installed VBO version is compatible with the minimum required one
if (version_compare(VIKBOOKING_SOFTWARE_VERSION, PRICELABS_VBO_MINIMUM_REQUIRED_VERSION, '<'))
{
    throw new RuntimeException(
        sprintf(
            'The currently installed version of <strong>VikBooking</strong> (%s) is not compatible with the minimum required one by <strong>Pricelabs E4jConnect-VikBooking</strong>! You need to have at least the <strong>%s</strong> version installed. Please update it to the latest version.',
            VIKBOOKING_SOFTWARE_VERSION,
            PRICELABS_VBO_MINIMUM_REQUIRED_VERSION
        ),
        505 // version not supported
    );
}

// make sure VikChannelManager is installed and active
if (!is_plugin_active('vikchannelmanager/vikchannelmanager.php'))
{
    throw new RuntimeException(
        '<span>Vik Channel Manager must be installed and activated!</span>',
        423 // locked
    );
}

// include VikChannelManager's defines
require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'vikchannelmanager' . DIRECTORY_SEPARATOR . 'defines.php';

// make sure the installed VCM version is compatible with the minimum required one
if (version_compare(VIKCHANNELMANAGER_SOFTWARE_VERSION, PRICELABS_VCM_MINIMUM_REQUIRED_VERSION, '<'))
{
    throw new RuntimeException(
        sprintf(
            'The currently installed version of <strong>Vik Channel Manager</strong> (%s) is not compatible with the minimum required one by <strong>Pricelabs E4jConnect-VikBooking</strong>! You need to have at least the <strong>%s</strong> version installed. Please update it to the latest version.',
            VIKCHANNELMANAGER_SOFTWARE_VERSION,
            PRICELABS_VCM_MINIMUM_REQUIRED_VERSION
        ),
        505 // version not supported
    );
}

// register custom namespace for this plugin
JLoader::registerNamespace('E4JConnect\\Pricelabs', dirname(__FILE__) . '/libraries', false, false, 'psr4');
