<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  API
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\API\Events;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\API\Event;

/**
 * E4jConnect Pricelabs Room Rates Updater implementation.
 *
 * @since 1.0
 */
class RoomRatesUpdaterEvent implements Event
{
    /**
     * @inheritDoc
     */
    public function getAccess($role, $action)
    {
        return [$role, 'core.admin'];
    }

    /**
     * @inheritDoc
     */
    public function dispatch($input, $response, $apiUser)
    {
        $processor = \E4JConnect\Pricelabs\Core\Factory::getContainer()->get('job.processor');

        /**
         * Speed up the implementation of the rate variations.
         * 
         * @since 2.0
         */
        $builder = new \E4JConnect\Pricelabs\Job\Builders\RARLazyBuilder($apiUser);

        foreach ($builder->getCommandsFromRequest($input) as $command)
        {
            $processor->register($command);
        }

        $response->body = [
            'id_queue' => $processor->getQueueID(),
        ];
    }
}
