<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  DI
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\DI;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * Defines the interface for a Container Aware class.
 *
 * @since  1.0
 */
interface ContainerAwareInterface
{
    /**
     * Sets the DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  static     This object to support chaining.
     */
    public function setContainer(Container $container)
}
