<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs Collection interface.
 *
 * @since 1.0
 */
interface Collection
{
    /**
     * Creates a queue of jobs.
     * 
     * @param   string  $id     Queue signature ID.
     * @param   string  $event  Queue event type.
     * 
     * @return  void
     */
    public function createQueue(string $id, ?string $event = null);

    /**
     * Adds a command to the currently registered queue.
     * 
     * @param   Command
     * 
     * @return  void
     */
    public function push(Command $command);

    /**
     * Returns the next executable command.
     * 
     * @return  Command
     */
    public function pull();

    /**
     * Updates the execution results.
     * 
     * @param   Command
     * @param   Result
     * 
     * @return  void
     */
    public function complete(Command $command, Result $result);
}
