<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job\Commands;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\Job\Command;

/**
 * This implementation aggregates a list of RAR commands to simultaneously execute them at once.
 *
 * @since 2.1
 */
class RARGroupExecutionCommand extends GroupExecutionCommand
{
    /** @var array */
    protected $options;

    /**
     * @inheritDoc
     * 
     * @param  array  $options  A configuration array holding the following attributes:
     *                          - room_id
     *                          - date_from
     *                          - date_to
     */
    public function __construct(array $commands, array $options)
    {
        parent::__construct($commands);

        $this->options = $options;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        if (method_exists('VikBooking', 'preloadSeasonRecords'))
        {
            // preload rates for a faster execution
            \VikBooking::preloadSeasonRecords([$this->options['room_id']], strtotime($this->options['date_from']), strtotime($this->options['date_to']));
        }

        $result = parent::execute();

        if (method_exists('VikBooking', 'preloadSeasonRecords'))
        {
            // unset preloaded rates to prevent unexpected behaviors due to a cache statically registered
            \VikBooking::preloadSeasonRecords([$this->options['room_id']], false);
        }

        return $result;
    }

    /**
     * @inheritDoc
     */
    protected function preflight(Command $command)
    {
        if (!$command instanceof RARCommand)
        {
            throw new \InvalidArgumentException('Only RARCommands are supported, ' . get_class($command) . ' given.', 406);
        }
    }
}
