<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\MVC\Models;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

// load dependencies
\JLoader::import('adapter.mvc.model');

/**
 * E4jConnect Pricelabs queues model.
 *
 * @since 1.0
 */
class QueuesModel extends \JModel
{
    /** @var int */
    protected $total;

    /**
     * Returns a list of queues.
     * 
     * @param   array  $filters   Optional search filters.
     * @param   array  $options   Pagination and sorting data.
     * 
     * @return  object[]
     */
    public function getList(array $filters = [], array $options = [])
    {
        $dbo = \JFactory::getDbo();

        $q = $dbo->getQuery(true)
            ->select('*')
            ->from($dbo->qn('#__e4jconnect_pricelabs_queue'));

        if (!empty($filters['search']))
        {
            $q->where($dbo->qn('signature') . ' = ' . $dbo->q($filters['search']));
        }

        if (!empty($filters['event']))
        {
            $q->where($dbo->qn('event') . ' LIKE ' . $dbo->q("%{$filters['event']}%"));
        }

        if (!empty($filters['date']))
        {
            $tz = \JFactory::getApplication()->get('offset', 'UTC');

            $start = \JFactory::getDate($filters['date'] . ' 00:00:00', $tz);
            $end   = \JFactory::getDate($filters['date'] . ' 23:59:59', $tz);

            $q->where($dbo->qn('createdon') . ' BETWEEN ' . $dbo->q($start) . ' AND ' . $dbo->q($end));
        }

        $q->order($dbo->qn($options['ordering'] ?? 'id') . ' ' . ($options['direction'] ?? 'DESC'));

        $dbo->setQuery($q, $options['start'] ?? 0, $options['limit'] ?? null);
        $queues = $dbo->loadObjectList();

        if (!empty($options['start']) || !empty($options['limit']))
        {
            // clear default statements to obtain all the records
            $q->clear('select')->clear('order')->clear('offset')->clear('limit');
            // count the rows instead of returning them all
            $q->select('COUNT(1)');

            // count total records
            $dbo->setQuery($q);
            $this->total = (int) $dbo->loadResult();
        }
        else
        {
            $this->total = count($queues);
        }

        return $queues;
    }

    /**
     * Returns the total number of records in the list.
     * 
     * @return  int
     */
    public function getTotal()
    {
        return $this->total;
    }
}
