<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  API
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\API\Events;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\API\Event;

/**
 * E4jConnect Pricelabs Queue Summary Event implementation.
 *
 * @since 1.0
 */
class QueueSummaryEvent implements Event
{
    /**
     * @inheritDoc
     */
    public function getAccess($role, $action)
    {
        return [$role, 'core.admin'];
    }

    /**
     * @inheritDoc
     */
    public function dispatch($input, $response, $apiUser)
    {
        $queueId = $input->getString('id_queue');

        if (!$queueId)
        {
            throw new \InvalidArgumentException('Missing queue identifier', 400);
        }

        $queueModel = new \E4JConnect\Pricelabs\MVC\Models\QueueModel;

        $queue = $queueModel->getSummary($queueId);

        // unset unneeded properties
        unset($queue->id);

        // set response
        $response->body = $queue;
    }
}
