<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  Core
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Core;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\DI\Container;

/**
 * Platform factory class.
 *
 * @since 1.0
 */
abstract class Factory
{
    /**
     * Global container object.
     *
     * @var Container
     */
    protected static $container = null;

    /**
     * Returns the global service container object, only creating it if it doesn't already exist.
     *
     * @return  Container
     */
    public static function getContainer()
    {
        if (!static::$container)
        {
            // create the default container during the first set up
            static::$container = static::createContainer();
        }

        return static::$container;
    }

    /**
     * Creates the global container object.
     *
     * @return  Container
     */
    protected static function createContainer()
    {
        $container = (new Container())
            ->registerServiceProvider(new \E4JConnect\Pricelabs\Service\Provider\System)
            ->registerServiceProvider(new \E4JConnect\Pricelabs\Service\Provider\JobProcessor)
            ->registerServiceProvider(new \E4JConnect\Pricelabs\Service\Provider\APIEvents);

        /**
         * Fires the action after completing the set up of the container used to dispatch the classes.
         * It is useful to override the default classes provided by the system.
         * 
         * @param  Container  $container  The container instance.
         * 
         * @since  1.0
         */
        do_action('e4jconnect_pricelabs_container_setup', $container);

        return $container;
    }
}
