<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs Command interface.
 *
 * @since 1.0
 */
interface Command
{
	/**
     * Returns the command summary.
     * 
     * @return  string
     */
    public function getSummary();

    /**
     * Returns the command extra data.
     * 
     * @return  string
     */
    public function getExtraData();

    /**
     * Executes the command.
     * 
     * @return  Result
     */
    public function execute();
}
