<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\MVC\Models;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

// load dependencies
\JLoader::import('adapter.mvc.models.form');

/**
 * E4jConnect Pricelabs jobs model.
 *
 * @since 1.0
 */
class JobModel extends \JModelForm
{
    /**
     * @inheritDoc
     */
    public function getTable($name = '', $prefix = 'JTable', $options = [])
    {
        if (!$name)
        {
            $name = $this->getName();
        }

        return new \E4JConnect\Pricelabs\MVC\Tables\JobTable(\JFactory::getDbo());
    }

    /**
     * Attempts to get the next job to process.
     * 
     * @return  object|null
     */
    public function getNextJob()
    {
        $dbo = \JFactory::getDbo();

        $q = $dbo->getQuery(true)
            ->select('*')
            ->from($dbo->qn('#__e4jconnect_pricelabs_jobs'))
            ->where($dbo->qn('status') . ' IS NULL')
            ->where($dbo->qn('executedon') . ' IS NULL')
            ->order($dbo->qn('createdon') . ' ASC')
            ->order($dbo->qn('id') . ' ASC');

        $dbo->setQuery($q, 0, 1);
        $job = $dbo->loadObject();

        if ($job)
        {
            $job->command = unserialize($job->command);
        }

        return $job;
    }
}
