<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\MVC\Tables;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs jobs table.
 *
 * @since 1.0
 */
class JobTable extends \JTable
{
    /**
     * Class constructor.
     *
     * @param  object  $db  The database driver instance.
     */
    public function __construct($db)
    {
        parent::__construct('#__e4jconnect_pricelabs_jobs', 'id', $db);
    }

    /**
     * @inheritDoc
     */
    public function bind($src, $ignore = [])
    {
        $src = (array) $src;

        if (empty($src['id']))
        {
            if (empty($src['createdon']))
            {
                $src['createdon'] = \JFactory::getDate()->toSql();
            }
        }

        if (!empty($src['command']) && is_object($src['command']))
        {
            $src['command'] = serialize($src['command']);
        }

        if (!empty($src['results']) && !is_scalar($src['results']))
        {
            $src['results'] = json_encode($src['results']);
        }

        return parent::bind($src, $ignore);
    }
}
