<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\WordPress\Update;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * Implements the abstract methods to fix an update.
 *
 * Never use exit() and die() functions to stop the flow.
 * Return false instead to break process safely.
 * 
 * @since 1.0
 */
class Fixer
{
    /**
     * The current version.
     *
     * @var string
     */
    protected $version;

    /**
     * Class constructor.
     */
    public function __construct($version)
    {
        $this->version = $version;
    }

    /**
     * This method is called before the SQL installation.
     *
     * @return  bool  True to proceed with the update, otherwise false to stop it.
     */
    public function beforeInstallation()
    {
        return true;
    }

    /**
     * This method is called after the SQL installation.
     *
     * @return  bool  True to proceed with the update, otherwise false to stop it.
     */
    public function afterInstallation()
    {
        return true;
    }
}
