<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  API
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\API;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs Event interface.
 *
 * @since 1.0
 */
interface Event
{
    /**
     * Returns a list of role-action access for validation.
     * 
     * @param   string  $role
     * @param   string  $action
     * 
     * @return  array
     */
    public function getAccess($role, $action);

    /**
     * Dispatches the current event.
     * 
     * @param   \JInput  $input
     * @param   object   $response
     * @param   string   $apiUser
     * 
     * @return  void
     */
    public function dispatch($input, $response, $apiUser);
}
