<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  DI
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\DI;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\DI\Exception\ContainerNotFoundException;

/**
 * Defines the trait for a Container Aware Class.
 *
 * @since 1.0
 */
trait ContainerAwareTrait
{
    /** @var Container */
    private $container;

    /**
     * Gets the DI container.
     *
     * @return  Container
     *
     * @throws  ContainerNotFoundException  May be thrown if the container has not been set.
     */
    protected function getContainer()
    {
        if ($this->container)
        {
            return $this->container;
        }

        throw new ContainerNotFoundException('Container not set in ' . get_class($this));
    }

    /**
     * Sets the DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  self       This object to support chaining.
     */
    public function setContainer(Container $container)
    {
        $this->container = $container;

        return $this;
    }
}
