<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job\Builders;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs RARBuilder implementation.
 *
 * @since 1.0
 */
class RARBuilder
{
    /** @var string */
    protected $apiUser;

    /**
     * Class constructor.
     * 
     * @param   string  $user
     */
    public function __construct($user)
    {
        $this->apiUser = $user;
    }

    /**
     * Builds a list of commands from the request.
     * 
     * @param   \JInput  $input
     * 
     * @return  Command[]
     */
    public function getCommandsFromRequest($input)
    {
        // gather default request data
        $default_data = [
            'room_id'  => $input->getUint('room_id', 0),
            'upd_vbo'  => $input->getUint('upd_vbo', 1),
            'upd_otas' => $input->getUint('upd_otas', 0),
        ];

        $commands = [];

        // scan jobs list
        foreach ($input->get('rates_data', [], 'array') as $rates_data)
        {
            // normalize request properties
            if (isset($rates_data['fdate']) && isset($rates_data['tdate']))
            {
                $rates_data['date_from'] = $rates_data['fdate'];
                $rates_data['date_to']   = $rates_data['tdate'];
                unset($rates_data['fdate'], $rates_data['tdate']);
            }

            // adjust command data
            $command_data = [
                'date_from'  => $rates_data['date_from'] ?? '',
                'date_to'    => $rates_data['date_to'] ?? '',
                'minlos'     => $rates_data['minlos'] ?? 0,
                'maxlos'     => $rates_data['maxlos'] ?? 0,
                'cta'        => $rates_data['cta'] ?? null,
                'ctd'        => $rates_data['ctd'] ?? null,
                'cta_wdays'  => $rates_data['cta_wdays'] ?? [],
                'ctd_wdays'  => $rates_data['ctd_wdays'] ?? [],
                'rates_data' => [
                    [
                        'rate_id' => $rates_data['rate_id'] ?? null,
                        'cost'    => $rates_data['cost'] ?? 0,
                    ],
                ],
            ];

            // push command
            $commands[] = new \E4JConnect\Pricelabs\Job\Commands\RARCommand(array_merge($default_data, $command_data), $this->apiUser);
        }

        return $commands;
    }
}
