<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs Result interface.
 *
 * @since 1.0
 */
interface Result
{
    /**
     * Returns a list of successful operations.
     * 
     * @return  array
     */
    public function getSuccesses();

    /**
     * Returns a list of erroneous operations.
     * 
     * @return  array
     */
    public function getErrors();

    /**
     * Returns a list of operations with warnings.
     * 
     * @return  array
     */
    public function getWarnings();
}
