<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  job
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Job\Results;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\Job\Result;

/**
 * E4jConnect Pricelabs JsonResult implementation.
 *
 * @since 1.0
 */
class JsonResult implements Result, \JsonSerializable
{
    /** @var object */
    protected $json;

    /**
     * Class constructor.
     * 
     * @param  mixed  $json  Either a JSON string or an array|object of data.
     */
    public function __construct($json)
    {
        if (is_string($json))
        {
            $json = json_decode($json);
        }

        $this->json = (object) $json;
    }

    /**
     * @inheritDoc
     */
    public function getSuccesses()
    {
        return $this->json->success ?? [];
    }

    /**
     * @inheritDoc
     */
    public function getErrors()
    {
        return $this->json->errors ?? [];
    }

    /**
     * @inheritDoc
     */
    public function getWarnings()
    {
        return $this->json->warnings ?? [];
    }

    /**
     * @inheritDoc
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return $this->json;
    }
}
