<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\MVC\Tables;

// No direct access to this file
defined('ABSPATH') or die('No script kiddies please!');

/**
 * E4jConnect Pricelabs queue table.
 *
 * @since 1.0
 */
class QueueTable extends \JTable
{
    /**
     * Class constructor.
     *
     * @param  object  $db  The database driver instance.
     */
    public function __construct($db)
    {
        parent::__construct('#__e4jconnect_pricelabs_queue', 'id', $db);
    }

    /**
     * @inheritDoc
     */
    public function bind($src, $ignore = [])
    {
        $src = (array) $src;

        if (empty($src['id']))
        {
            if (empty($src['signature']))
            {
                $src['signature'] = md5(uniqid());
            }

            if (empty($src['createdon']))
            {
                $src['createdon'] = \JFactory::getDate()->toSql();
            }
        }

        return parent::bind($src, $ignore);
    }
}
