<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  Service
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\Service\Provider;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

use E4JConnect\Pricelabs\DI\Container;
use E4JConnect\Pricelabs\DI\ContainerDecorator;
use E4JConnect\Pricelabs\DI\ServiceProviderInterface;

/**
 * Service provider for the API events.
 *
 * @since 1.0
 */
class APIEvents implements ServiceProviderInterface
{
    /**
     * @inheritDoc
     */
    public function register(Container $container)
    {
        // register set room rates API request
        $container->set('request.pricelabs_set_room_rates', function() {
            return new \E4JConnect\Pricelabs\API\Events\RoomRatesUpdaterEvent;
        });

        // register async queue summary API request
        $container->set('request.pricelabs_async_queue_summary', function() {
            return new \E4JConnect\Pricelabs\API\Events\QueueSummaryEvent;
        });
    }
}
