<?php
/** 
 * @package     Pricelabs E4jConnect-VikBooking
 * @subpackage  wordpress
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2024 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com | https://e4jconnect.com
 */

namespace E4JConnect\Pricelabs\WordPress\Language;

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

\JLoader::import('adapter.language.handler');

/**
 * Switcher class to translate the queue events.
 *
 * @since 1.0
 */
class QueueEventHandler implements \JLanguageHandler
{
    /**
     * @inheritDoc
     */
    public function translate($string)
    {   
        $result = null;

        /**
         * Translations go here.
         * @tip Use 'TRANSLATORS:' comment to attach a description of the language.
         */

        switch ($string)
        {
            case 'rarcommand':
                $result = __('Rates Update', 'e4jconnect-pricelabs');
                break;

            case 'groupexecutioncommand':
                $result = __('Multi-event Execution', 'e4jconnect-pricelabs');
                break;

            case 'rarbulkcommand':
                $result = __('OTAs Rates Bulk', 'e4jconnect-pricelabs');
                break;
        }

        return $result;
    }
}
