<?php
/** 
 * @package   	VikReCAPTCHA
 * @subpackage 	core
 * @author    	E4J s.r.l.
 * @copyright 	Copyright (C) 2019 E4J s.r.l. All Rights Reserved.
 * @license  	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link 		https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * Helper class used to collect the feedback of the users.
 * Should be attached to `plugin_action_links` WordPress filter.
 *
 * @since 1.0
 */
class VikFeedbackHandler
{
	/**
	 * Attaches a feeback modal to the deactivation button.
	 *
	 * @param 	array 	$actions 	An array of plugin action links.
	 * @param 	string 	$plugin 	Path to the plugin file relative to the plugins directory.
	 *
	 * @return 	array 	The filtered actions.
	 */
	public static function deactivate($actions, $plugin)
	{
		// make sure the plugin is recaptcha and the deactivation link is available
		if ($plugin != 'vikrecaptcha/vikrecaptcha.php' || !isset($actions['deactivate']))
		{
			return $actions;
		}

		// check whether the safe-word is set in the request
		if (isset($_REQUEST['feedback']) && $_REQUEST['feedback'] == 0)
		{
			// skip deactivation feedback
			return $actions;
		}

		// extract deactivation URL from link
		if (!preg_match("/href=\"([^\"]*)\"/i", $actions['deactivate'], $match))
		{
			// unable to extract URL from deactivation link
			return $actions;
		}

		$deactivate_url = end($match);

		// define URL to popup thickbox
		$url = '#TB_inline?width=500&height=400&inlineId=vikrecaptcha-feedback';

		$__title = __('Feedback', 'vikrecaptcha');

		// add support for feedback
		$actions['deactivate'] = sprintf(
			'<a href="%s" class="thickbox" aria-label="%s" data-name="%s">%s</a>',
			esc_attr($url),
			esc_attr(sprintf(__('Deactivate %s', 'plugin'), 'VikReCAPTCHA')),
			esc_attr($__title),
			__('Deactivate')
		);

		// append thickbox to admin footer
		add_action('admin_footer', function() use ($deactivate_url)
		{
			// make URL safe for JS
			$deactivate_url_js = str_replace('&amp;', '&', $deactivate_url);

			// include feedback template
			include dirname(__FILE__) . DIRECTORY_SEPARATOR . 'template.php';
		});

		return $actions;
	}

	/**
	 * Notifies the feedback to vikwp server.
	 * Feedback data can be found within the request array.
	 *
	 * @return 	void
	 */
	public static function notify()
	{
		// validation end-points
		$url = 'https://vikwp.com/api/?task=logs.track';

		global $wp_version;

		$env = array(
			'ipaddr'  => $_SERVER['REMOTE_ADDR'],
			'wpver'   => $wp_version,
			'version' => '1.0',
			'phpver'  => phpversion(),
		);

		$body = print_r($env, true);

		if (!empty($_REQUEST['notes']))
		{
			$body = stripslashes($_REQUEST['notes']) . "\n\n" . $body;
		}

		$args = array(
			'body' => array(
				'type' => 'feedback.vikrecaptcha',
				'desc' => stripslashes($_REQUEST['type']),
				'body' => $body,
			),
		);

		// make connection with Google
		$response = wp_remote_post($url, $args);

		if (is_wp_error($response))
		{
			// an error occurred
			throw new Exception($response->get_error_message());
		}
		
		echo $response['body'];
	}
}
