# Vik ReCAPTCHA

This plugin acts as a bridge to support the usage of reCAPTCHA on any **VIK** plugins.

## Configuration

This plugin owns an internal system that can be used to configure reCAPTCHA (v2 only).
Since there is no admin interface, the configuration can be completed only by altering
the database manually. Here's a list of supported options:

| Name                      | Type                  | Default | Status       |
|---------------------------|-----------------------|---------|--------------|
| `vikrecaptcha_version`    | currently only "2.0"  | 2.0     | Optional     |
| `vikrecaptcha_public_key` | any                   | none    | **Required** |
| `vikrecaptcha_secret_key` | any                   | none    | **Required** |
| `vikrecaptcha_theme`      | "light" or "dark"     | light   | Optional     |
| `vikrecaptcha_size`       | "normal" or "compact" | normal  | Optional     |

In order to setup the system, it is needed to open the database panel and launch the following SQL query:

```sql
INSERT INTO `wp_options` (`option_name`, `option_value`) VALUES
('vikrecaptcha_public_key', '[SITE_KEY_GOES_HERE]'),
('vikrecaptcha_secret_key', '[SECRET_KEY_GOES_HERE]');
```

Don't forget to replace `wp_` with the real prefix used by the database.

It is also possible to specify the configuration options at runtime by using a specific hook.

```php
add_filter('vik_recaptcha_driver_options', function(array $options) {
	// alter here the configuration settings
	$options['publickey'] = '[SITE_KEY_GOES_HERE]';
	$options['secretkey'] = '[SECRET_KEY_GOES_HERE]';

	return $options;
});
```

---

Otherwise, if you already have a plugin to include reCAPTCHA on your WordPress website, just make sure that it is supported by our plugin.

## CAPTCHA 4WP – Antispam CAPTCHA solution for WordPress

You can install the plugin below and configure it by using its admin panel to start supporting reCAPTCHA (v2, v3, invisible) on **VIK** plugins too.
https://wordpress.org/plugins/advanced-nocaptcha-recaptcha/

## reCaptcha by BestWebSoft

You can install the plugin below and configure it by using its admin panel to start supporting reCAPTCHA (v2, v3, invisible) on **VIK** plugins too.
https://wordpress.org/plugins/google-captcha/

**NOTE:** in order to use reCAPTCHA on custom forms, our plugin must be enabled from the **GCB** admin panel, by accessing the section below:
> **Google Captcha** > **Enable reCaptcha for** > **Custom Forms**
where **VikReCAPTCHA** option must be turned on.

---

## Other Plugins

If you are a developer (or someone with a basic PHP knowledge) and you would like to use a different reCAPTCHA plugin, you can do it by attaching that plugin to some **actions** and **filters**.

### Make reCAPTCHA available

Register the **filter** below to inform the **VIK** plugins that reCAPTCHA is available and can be used.

```php
add_filter('vik_recaptcha_on', function($on = false) {
	return true;
});
```

### Display reCAPTCHA

Register the **action** below to display the reCAPTCHA module every time the **VIK** plugins request it.
Since other plugins might be attached to the same hook and could be executed earlier, it is good practice to make sure that the response hasn't been yet manipulated.
The HTML to display must be attached to `$response` argument.

```php
add_action('vik_recaptcha_display', function(&$response, array $options = []) {
	// go ahead only if none else manipulated the response
	if ($response === null) {
		// Code used to render reCAPTCHA goes here.
		// The rendered HTML must be attached to $response argument.
	}
}, 10, 2);
```

### Validate reCAPTCHA token

Register the **action** below to validate the reCAPTCHA token that has been previously submitted.
Since other plugins might be attached to the same hook and could be executed earlier, it is good practice to make sure that the response hasn't been yet validated.
Assign `true`|`false` to `$response` argument to complete the validation. In case of detailed errors, it is also possible to throw **exceptions**.

```php
add_action('vik_recaptcha_check', function(&$response, array $options = []) {
	// go ahead only if none else manipulated the response
	if ($response === null) {
		// Code used to validate reCAPTCHA token goes here.
		// Assign true|false to $response to complete the validation.
	}
}, 10, 2);
```

---

## Trigger VikReCAPTCHA on other plugins

If you own a plugin (not related to reCAPTCHA) and you would like to integrate our reCAPTCHA on your forms, you have just to insert the snippets below on your code.

### Check if reCAPTCHA can be used

```php
$is = apply_filters('vik_recaptcha_on', false);
// $is === true means that reCAPTCHA can be used
```

### Display reCAPTCHA on your forms

```php
$html = null;
// an optional configuration array (just leave empty)
$options = [];
// trigger reCAPTCHA display event to fill $html var
do_action_ref_array('vik_recaptcha_display', [&$html, $options]);
// display reCAPTCHA by echoing it (empty in case reCAPTCHA is not available)
echo $html;
```

### Validate reCAPTCHA on your tasks

```php
$success = null;
// an optional configuration array (just leave empty)
$options = [];
// trigger reCAPTCHA check event to validate the submitted token
do_action_ref_array('vik_recaptcha_check', [&$success, $options]);
// $success === true means that reCAPTCHA has been properly validated
```