<?php
/** 
 * @package   	VikReCAPTCHA
 * @subpackage 	core
 * @author    	E4J s.r.l.
 * @copyright 	Copyright (C) 2019 E4J s.r.l. All Rights Reserved.
 * @license  	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link 		https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

$doc_url = plugin_dir_url(VIKRECAPTCHA_PATH) . 'readme.html';

$options = array(
	array(
		'value'   => '0',
		'text'    => __('No, thanks', 'vikrecaptcha'),
		'checked' => true,
	),
	array(
		'value'  => 'The plugin is not working',
		'text'   => __('The plugin is not working', 'vikrecaptcha'),
		'notes'  => true,
	),
	array(
		'value'  => 'The plugin didn\'t work as expected',
		'text'   => __('The plugin didn\'t work as expected', 'vikrecaptcha'),
		'notes'  => true,
	),
	array(
		'value'  => 'The plugin suddenly stopped working',
		'text'   => __('The plugin suddenly stopped working', 'vikrecaptcha'),
		'notes'  => true,
	),
	array(
		'value'  => 'The plugin broke my site',
		'text'   => __('The plugin broke my site', 'vikrecaptcha'),
		'notes'  => array(
			'placeholder' => __('Please, could you explain what happened?', 'vikrecaptcha'),
		),
	),
	array(
		'value'  => 'I couldn\'t understand how to get it work',
		'text'   => __('I couldn\'t understand how to get it work', 'vikrecaptcha'),
		'help'   => sprintf(__('Did you read the plugin documentation? You can find it <a href="%s" target="_blank">here</a>.', 'vikrecaptcha'), $doc_url),
	),
	array(
		'value'  => 'I no longer need the plugin',
		'text'   => __('I no longer need the plugin', 'vikrecaptcha'),
	),
	array(
		'value'  => 'I\'m just debugging an issue',
		'text'   => __('I\'m just debugging an issue', 'vikrecaptcha'),
	),
	array(
		'value'  => 'I\'m not able to deactivate this plugin!',
		'text'   => __('I\'m not able to deactivate this plugin!', 'vikrecaptcha'),
		'help'   => __('In case you are experiencing some issues with the deactivation of this plugin, try to relaunch the page by appending <code>&feedback=0</code> to the URL.', 'vikrecaptcha'),
	),
	array(
		'value'  => 'Other',
		'text'   => __('Other', 'vikrecaptcha'),
		'notes'  => array(
			'required'    => true,
			'placeholder' => __('Please, provide us some information', 'vikrecaptcha'),
		),
	),
);

?>

<style>
	.thickbox-loading {
		height: auto !important;
	}
	#TB_ajaxContent {
		width: calc(100% - 30px) !important;
		height: calc(100% - 45px) !important;
	}
	.th-box-body {
		height: calc(100% - 45px);
	}
	.th-box-footer {
		text-align: right;
	}

	.th-box-body div.form-field {
		margin: 5px 0;
	}

	.th-box-body blockquote {
		color: #7f8fa4;
		font-size: inherit;
		padding: 8px 24px;
		border-left: 4px solid #eaeaea;
		background: #fff;
	}

	textarea.invalid {
		border: 1px solid #900;
	}
</style>

<div id="vikrecaptcha-feedback" style="display: none;">

	<div class="th-box-body">
		<h2><?php echo __('Feedback', 'vikrecaptcha'); ?></h2>
		<h3><?php echo __('If you have a moment, please let us know why you are deactivating.', 'vikrecaptcha'); ?></h3>

		<form id="feedback-form">

			<?php
			foreach ($options as $i => $opt)
			{
				?>
				<div class="form-field">
					<input
						type="radio"
						id="feed-opt-<?php echo $i; ?>"
						name="feedback_type"
						value="<?php echo esc_attr($opt['value']); ?>"
						<?php echo !empty($opt['checked']) ? 'checked="checked"' : ''; ?>
					/>
					<label for="feed-opt-<?php echo $i; ?>"><?php echo $opt['text']; ?></label>

					<?php
					if (!empty($opt['help']))
					{
						?>
						<blockquote
							class="feedback-help"
							style="<?php echo !empty($opt['checked']) ? '' : 'display:none;'; ?>"
						>
							<?php echo $opt['help']; ?>
						</blockquote>
						<?php
					}

					if (!empty($opt['notes']))
					{
						$opt['notes'] = (array) $opt['notes'];

						$placeholder = !empty($opt['notes']['placeholder'])
							? $opt['notes']['placeholder']
							: __('Please, could you write some extra notes?', 'vikrecaptcha');

						?>
						<textarea
							class="feedback-notes<?php echo !empty($opt['notes']['required']) ? ' required' : ''; ?>"
							placeholder="<?php echo $placeholder; ?>"
							style="<?php echo !empty($opt['checked']) ? '' : 'display:none;'; ?>"
						></textarea>
						<?php
					}
					?>

				</div>
				<?php
			}
			?>

			<p>
				<small>
					<span class="dashicons dashicons-editor-help"></span>&nbsp;
					<?php echo __('In addition to the specified information, the feedback will contain your IP address (for security reasons), your PHP version, your WordPress version and the plugin version.', 'vikrecaptcha'); ?>
				</small>
			</p>

		</form>
	</div>

	<div class="th-box-footer">
		<a href="javascript: void(0);" id="vikrecaptcha-deactivate" class="button button-primary">
			<?php echo __('Deactivate'); ?>
		</a>
	</div>

</div>

<script>
	jQuery(document).ready(function() {

		jQuery('.form-field input[name="feedback_type"]').on('change', function() {
			var radio = jQuery('input[name="feedback_type"]:checked');

			jQuery('.feedback-help,.feedback-notes').hide();
			radio.siblings('.feedback-help,.feedback-notes').show();
		});

		jQuery('#vikrecaptcha-deactivate').on('click', function() {
			var radio = jQuery('input[name="feedback_type"]:checked');

			// get selected feedback type
			var type = radio.val();

			if (type == '0') {
				// deactivate automatically
				document.location.href = '<?php echo $deactivate_url_js; ?>';
				return;
			}

			// get textarea
			var textarea = radio.siblings('.feedback-notes');
			var comment  = textarea.length ? textarea.val() : null;

			if (textarea.length && !textarea.val().length && textarea.hasClass('required')) {
				textarea.addClass('invalid');
				return;
			}

			// disable button
			jQuery(this).attr('disabled', true);

			textarea.removeClass('invalid');

			// do ajax and redirect on success/failure
			jQuery.ajax({
				url: 'admin-ajax.php?action=vikrecaptcha&task=feedback',
				type: 'post',
				data: {
					type:  type,
					notes: comment,
				},
			}).done(function(resp) {
				// complete deactivation
				document.location.href = '<?php echo $deactivate_url_js; ?>';
			}).fail(function(err) {
				console.log(err);
				// complete deactivation
				document.location.href = '<?php echo $deactivate_url_js; ?>';
			});
		});

	});
</script>