<?php
/** 
 * @package   	VikReCAPTCHA
 * @subpackage 	core
 * @author    	E4J s.r.l.
 * @copyright 	Copyright (C) 2019 E4J s.r.l. All Rights Reserved.
 * @license  	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link 		https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * Google Captcha (reCAPTCHA) by BestWebSoft handler.
 *
 * @link  https://wordpress.org/plugins/google-captcha/
 *
 * @since 1.0
 */
class VikRecaptchaDriverGcb implements VikRecaptchaDriver
{
	/**
	 * Displays the ReCAPTCHA element.
	 *
	 * @return 	string 	The HTML to display.
	 */
	public function display()
	{
		// display contents by passing "vikrecaptcha" as form slug
		return apply_filters('gglcptch_display_recaptcha', '', 'vikrecaptcha');
	}

	/**
	 * Checks whether ReCAPTCHA has been submitted properly.
	 *
	 * @return 	boolean  True if correct, false otherwise.
	 *
	 * @throws  Exception
	 */
	public function check()
	{
		// validate token by passing "vikrecaptcha" as form slug
		$response = apply_filters('gglcptch_verify_recaptcha', true, 'string', 'vikrecaptcha');
		
		if ($response !== true)
		{
			// something went wrong, raise an exception
			throw new Exception($response);
		}

		return $response;
	}

	/**
	 * Checks whether this driver can be used.
	 *
	 * @return 	boolean  True if usable, false otherwise.
	 */
	public function isSupported()
	{
		// check if is_plugin_active() function exists
		if (!function_exists('is_plugin_active'))
		{
			// load plugins.php file
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		// make sure ANR plugin is active
		return is_plugin_active('google-captcha/google-captcha.php');
	}
}
