<?php
/** 
 * @package   	VikReCAPTCHA
 * @subpackage 	core
 * @author    	E4J s.r.l.
 * @copyright 	Copyright (C) 2019 E4J s.r.l. All Rights Reserved.
 * @license  	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link 		https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * ReCAPTCHA handler interface.
 * The constructor receives an array of options.
 *
 * @since 1.0
 */
interface VikRecaptchaDriver
{
	/**
	 * Displays the ReCAPTCHA element.
	 *
	 * @return 	string 	The HTML to display.
	 */
	public function display();

	/**
	 * Checks whether ReCAPTCHA has been submitted properly.
	 *
	 * @return 	boolean  True if correct, false otherwise.
	 *
	 * @throws  Exception
	 */
	public function check();

	/**
	 * Checks whether this driver can be used.
	 *
	 * @return 	boolean  True if usable, false otherwise.
	 */
	public function isSupported();
}
