<?php
/** 
 * @package   	VikReCAPTCHA
 * @subpackage 	core
 * @author    	E4J s.r.l.
 * @copyright 	Copyright (C) 2019 E4J s.r.l. All Rights Reserved.
 * @license  	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link 		https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

/**
 * Advanced noCaptcha reCaptcha handler.
 *
 * @link  https://wordpress.org/plugins/advanced-nocaptcha-recaptcha/
 *
 * @since 1.0
 */
class VikRecaptchaDriverAnr implements VikRecaptchaDriver
{
	/**
	 * Displays the ReCAPTCHA element.
	 *
	 * @return 	string 	The HTML to display.
	 */
	public function display()
	{
		// start output buffer
		ob_start();
		// display ANR Captcha form field
		do_action('anr_captcha_form_field');
		// obtain output
		$output = ob_get_contents();
		// clean buffer
		ob_end_clean();

		return $output;
	}

	/**
	 * Checks whether ReCAPTCHA has been submitted properly.
	 *
	 * @return 	boolean  True if correct, false otherwise.
	 *
	 * @throws  Exception
	 */
	public function check()
	{
		// validate captcha
		return anr_verify_captcha();
	}

	/**
	 * Checks whether this driver can be used.
	 *
	 * @return 	boolean  True if usable, false otherwise.
	 */
	public function isSupported()
	{
		// check if is_plugin_active() function exists
		if (!function_exists('is_plugin_active'))
		{
			// load plugins.php file
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		// make sure ANR plugin is active
		return is_plugin_active('advanced-nocaptcha-recaptcha/advanced-nocaptcha-recaptcha.php');
	}
}
